/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWException;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkParticipantHistory;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.VWTrkTestDataField;
import filenet.vw.toolkit.runtime.VWTrkWorkObject;
import filenet.vw.toolkit.runtime.property.IVWFieldChangeEventListener;
import filenet.vw.toolkit.runtime.property.VWFieldChangeEvent;
import filenet.vw.toolkit.runtime.property.VWFieldsTableData;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public abstract class VWStepTableModelBase
extends AbstractTableModel
implements IVWFieldChangeEventListener {
    VWTrkStepOccurrence m_stepOccurrence = null;
    VWTrkParticipant m_participant = null;
    boolean m_bInitialized = false;
    BitSet m_type = null;
    Vector m_workObjects = null;
    Vector m_history = null;
    Vector m_data = new Vector();
    Vector m_columnNames = new Vector();
    boolean m_bTableEditable = false;

    public abstract Object getValueAt(int var1, int var2);

    public abstract void setValueAt(Object var1, int var2, int var3);

    protected abstract void initColumnNames();

    public abstract Class getColumnClass(int var1);

    public abstract boolean isCellEditable(int var1, int var2);

    protected abstract VWFieldsTableData newDataFieldInstance(VWTrkTestDataField var1) throws Exception;

    protected VWStepTableModelBase() {
        this.initColumnNames();
    }

    void setData(VWTrkStepOccurrence stepOccurrence, boolean editable) throws VWException, Exception {
        if (stepOccurrence == null) {
            this.setData((VWTrkWorkObject)null, (VWTrkParticipantHistory)null, editable);
        } else {
            this.m_stepOccurrence = stepOccurrence;
            this.m_participant = null;
            this.setData(stepOccurrence.getWorkObjectCollection(), stepOccurrence.getParticipantHistory(), true);
        }
    }

    protected void setData(VWTrkParticipant participant, boolean editable) throws VWException, Exception {
        if (participant == null) {
            return;
        }
        this.m_participant = participant;
        this.m_stepOccurrence = null;
        this.setData(participant.getParticipantWorkObject(), participant.getParticipantHistory(), true);
    }

    private void setData(Vector workObjects, Vector history, boolean editable) throws VWException, Exception {
        if (this.m_data != null) {
            this.m_data.removeAllElements();
        }
        this.m_bTableEditable = editable;
        this.addWorkObjectData(workObjects);
        this.addHistoryData(history);
    }

    private void setData(VWTrkWorkObject workObject, VWTrkParticipantHistory participantHistory, boolean editable) throws VWException, Exception {
        if (this.m_data != null) {
            this.m_data.removeAllElements();
        }
        this.m_bTableEditable = editable;
        Vector<VWTrkWorkObject> workObjects = new Vector<VWTrkWorkObject>();
        if (workObject != null) {
            workObjects.addElement(workObject);
        }
        Vector<VWTrkParticipantHistory> history = new Vector<VWTrkParticipantHistory>();
        if (participantHistory != null) {
            history.addElement(participantHistory);
        }
        this.addWorkObjectData(workObjects);
        this.addHistoryData(history);
    }

    private void setData(Vector workObjects, boolean editable) throws VWException, Exception {
        if (this.m_data != null) {
            this.m_data.removeAllElements();
        }
        this.m_bTableEditable = editable;
        this.addWorkObjectData(workObjects);
    }

    protected void addWorkObjectData(Vector workObjects) throws Exception {
        this.m_workObjects = workObjects != null ? (Vector)workObjects.clone() : new Vector();
        if (workObjects == null || workObjects.size() == 0) {
            return;
        }
        if (!(workObjects.elementAt(0) instanceof VWTrkWorkObject || workObjects != null && workObjects.size() != 0)) {
            return;
        }
        try {
            for (int i = 0; i < this.m_workObjects.size(); ++i) {
                VWTrkWorkObject workObject = (VWTrkWorkObject)this.m_workObjects.elementAt(i);
                VWTrkTestDataField[] vwDataFields = workObject.getDataFields();
                this.addDataFields(vwDataFields);
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex, VWResource.s_failedToContructFieldsTableModel);
            throw ex;
        }
    }

    protected void addHistoryData(Vector history) throws Exception {
        this.m_history = history != null ? (Vector)history.clone() : new Vector();
        if (history == null || history.size() == 0) {
            return;
        }
        if (!(history.elementAt(0) instanceof VWTrkParticipantHistory || history != null && history.size() != 0)) {
            return;
        }
        for (int i = 0; i < history.size(); ++i) {
            VWTrkParticipantHistory participantHistory = (VWTrkParticipantHistory)history.elementAt(i);
            VWTrkTestDataField[] vwDataFields = participantHistory.getLogFields();
            if (vwDataFields != null && vwDataFields.length != 0) {
                this.m_bTableEditable = false;
            }
            this.addDataFields(vwDataFields);
        }
    }

    protected void addDataFields(VWTrkTestDataField[] vwDataFields) {
        if (vwDataFields == null || vwDataFields.length == 0) {
            return;
        }
        for (int j = 0; j < vwDataFields.length; ++j) {
            if (!this.m_type.get(vwDataFields[j].getFieldType())) continue;
            VWFieldsTableData dataField = this.findDataField(vwDataFields[j].getName());
            if (dataField != null) {
                try {
                    dataField.collateDataField(vwDataFields[j]);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
                continue;
            }
            try {
                if (vwDataFields[j].getIsSystemField()) {
                    return;
                }
                dataField = this.newDataFieldInstance(vwDataFields[j]);
                dataField.addFieldChangeEventListener(this);
                String fieldName = dataField.getName();
                String name = null;
                boolean bInserted = false;
                for (int i = 0; i < this.m_data.size(); ++i) {
                    VWFieldsTableData field = (VWFieldsTableData)this.m_data.elementAt(i);
                    name = field.getName();
                    if (VWStringUtils.compareIgnoreCase(fieldName, name) >= 0) continue;
                    this.m_data.insertElementAt(dataField, i);
                    bInserted = true;
                    break;
                }
                if (bInserted) continue;
                this.m_data.addElement(dataField);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void clearData() {
        if (this.m_data != null) {
            this.m_data.removeAllElements();
        }
        this.m_workObjects = new Vector();
        this.m_history = new Vector();
    }

    protected VWFieldsTableData findDataField(String name) {
        if (this.m_data == null) {
            return null;
        }
        for (int i = 0; i < this.m_data.size(); ++i) {
            if (VWStringUtils.compare(((VWFieldsTableData)this.m_data.elementAt(i)).getName(), name) != 0) continue;
            return (VWFieldsTableData)this.m_data.elementAt(i);
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_data == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.m_data.size(); ++i) {
            VWFieldsTableData fieldsData = (VWFieldsTableData)this.m_data.elementAt(i);
            if (fieldsData.isExpanded()) {
                if (fieldsData.getSize() > 0) {
                    count += fieldsData.getSize();
                    continue;
                }
                ++count;
                continue;
            }
            ++count;
        }
        return count;
    }

    public int getColumnCount() {
        return this.m_columnNames.size();
    }

    public String getColumnName(int col) {
        if (col < this.getColumnCount()) {
            return (String)this.m_columnNames.elementAt(col);
        }
        return null;
    }

    public Vector getData() {
        return this.m_data;
    }

    protected VWFieldsTableData getDataField(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        Object value = null;
        int[] index = new int[2];
        boolean bFound = this.rowToFieldIndex(row, index);
        int fieldIndex = index[0];
        int rowIndex = index[1];
        if (bFound) {
            return (VWFieldsTableData)this.m_data.elementAt(fieldIndex);
        }
        return null;
    }

    public boolean rowToFieldIndex(int row, int[] index) {
        boolean bFound = false;
        int count = 0;
        for (int i = 0; i < this.m_data.size(); ++i) {
            int rowCount = 1;
            VWFieldsTableData datafield = (VWFieldsTableData)this.m_data.elementAt(i);
            rowCount = datafield.isExpanded() && datafield.getSize() > 0 ? datafield.getSize() : 1;
            if (row >= (count += rowCount)) continue;
            bFound = true;
            index[0] = i;
            index[1] = row - count + rowCount;
            break;
        }
        return bFound;
    }

    public void fieldChanged(VWFieldChangeEvent event) {
        if (event == null) {
            return;
        }
        Object source = event.getSource();
        if (source == null) {
            return;
        }
        if (event.isFieldType() && source instanceof VWFieldsTableData) {
            VWFieldsTableData dataField = (VWFieldsTableData)source;
            dataField.writeDataFieldsToWorkObjects(this.m_workObjects);
        }
    }

    public boolean isInRange(int row, int col) {
        return this.isRowInRange(row) && this.isColInRange(col);
    }

    public boolean isRowInRange(int row) {
        return row >= 0 && row < this.getRowCount();
    }

    public boolean isColInRange(int col) {
        return col >= 0 && col < this.getColumnCount();
    }

    public boolean isEditable() {
        if (this.m_stepOccurrence != null) {
            return this.m_stepOccurrence.isDataEditable();
        }
        if (this.m_participant != null) {
            return this.m_participant.isDataEditable();
        }
        return false;
    }

    public void removeReferences() {
        this.m_stepOccurrence = null;
        this.m_participant = null;
        if (this.m_workObjects != null) {
            this.m_workObjects.removeAllElements();
            this.m_workObjects = null;
        }
        if (this.m_history != null) {
            this.m_history.removeAllElements();
            this.m_history = null;
        }
        if (this.m_data != null) {
            for (int i = 0; i < this.m_data.size(); ++i) {
                Object obj = this.m_data.elementAt(i);
                if (obj == null || !(obj instanceof VWFieldsTableData)) continue;
                ((VWFieldsTableData)obj).removeFieldChangeEventListener(this);
                ((VWFieldsTableData)obj).removeReferences();
            }
            this.m_data.removeAllElements();
            this.m_data = null;
        }
        if (this.m_columnNames != null) {
            this.m_columnNames.removeAllElements();
            this.m_columnNames = null;
        }
    }
}

